/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.stone;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.api.capability.size.IItemSize;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.blocks.agriculture.BlockCropTFC;
import net.dries007.tfc.objects.blocks.plants.BlockPlantTFC;
import net.dries007.tfc.objects.blocks.stone.BlockFarmlandTFC;
import net.dries007.tfc.objects.blocks.stone.BlockPathTFC;
import net.dries007.tfc.objects.blocks.stone.BlockRockRaw;
import net.dries007.tfc.objects.blocks.stone.BlockRockSmooth;
import net.dries007.tfc.objects.blocks.stone.BlockRockSpike;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariantConnected;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariantFallable;
import net.dries007.tfc.objects.blocks.stone.BlockStoneAnvil;
import net.dries007.tfc.objects.items.rock.ItemRock;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockGrassPath;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BlockRockVariant
extends Block
implements IItemSize {
    private static final Map<Rock, EnumMap<Rock.Type, BlockRockVariant>> TABLE = new HashMap<Rock, EnumMap<Rock.Type, BlockRockVariant>>();
    protected final Rock.Type type;
    protected final Rock rock;

    public static BlockRockVariant get(Rock rock, Rock.Type type) {
        if (rock == null) {
            return TABLE.get((Object)Rock.GRANITE).get((Object)type);
        }
        return TABLE.get((Object)rock).get((Object)type);
    }

    public static BlockRockVariant create(Rock rock, Rock.Type type) {
        switch (type) {
            case RAW: {
                return new BlockRockRaw(type, rock);
            }
            case SMOOTH: {
                return new BlockRockSmooth(type, rock);
            }
            case ANVIL: {
                return new BlockStoneAnvil(type, rock);
            }
            case SPIKE: {
                return new BlockRockSpike(type, rock);
            }
            case FARMLAND: {
                return new BlockFarmlandTFC(type, rock);
            }
            case PATH: {
                return new BlockPathTFC(type, rock);
            }
            case GRASS: 
            case DRY_GRASS: 
            case CLAY_GRASS: {
                return new BlockRockVariantConnected(type, rock);
            }
            case SAND: 
            case DIRT: 
            case CLAY: 
            case GRAVEL: 
            case COBBLE: {
                return new BlockRockVariantFallable(type, rock);
            }
        }
        return new BlockRockVariant(type, rock);
    }

    public BlockRockVariant(Rock.Type type, Rock rock) {
        super(type.material);
        if (!TABLE.containsKey((Object)rock)) {
            TABLE.put(rock, new EnumMap(Rock.Type.class));
        }
        TABLE.get((Object)rock).put(type, this);
        this.type = type;
        this.rock = rock;
        if (type.isGrass) {
            this.func_149675_a(true);
        }
        switch (type) {
            case RAW: 
            case SMOOTH: 
            case ANVIL: 
            case SPIKE: 
            case BRICKS: {
                this.func_149672_a(SoundType.field_185851_d);
                this.func_149711_c(rock.getRockCategory().getHardness()).func_149752_b(rock.getRockCategory().getResistance());
                this.setHarvestLevel("pickaxe", 0);
                break;
            }
            case COBBLE: {
                this.func_149672_a(SoundType.field_185851_d);
                this.func_149711_c(rock.getRockCategory().getHardness() * 0.75f).func_149752_b(rock.getRockCategory().getResistance());
                this.setHarvestLevel("pickaxe", 0);
                break;
            }
            case SAND: {
                this.func_149672_a(SoundType.field_185855_h);
                this.func_149711_c(rock.getRockCategory().getHardness() * 0.05f);
                this.setHarvestLevel("shovel", 0);
                break;
            }
            case FARMLAND: 
            case PATH: 
            case DIRT: {
                this.func_149672_a(SoundType.field_185849_b);
                this.func_149711_c(rock.getRockCategory().getHardness() * 0.15f);
                this.setHarvestLevel("shovel", 0);
                break;
            }
            case CLAY: 
            case GRAVEL: {
                this.func_149672_a(SoundType.field_185849_b);
                this.func_149711_c(rock.getRockCategory().getHardness() * 0.2f);
                this.setHarvestLevel("shovel", 0);
                break;
            }
            case GRASS: 
            case DRY_GRASS: 
            case CLAY_GRASS: {
                this.func_149672_a(SoundType.field_185850_c);
                this.func_149711_c(rock.getRockCategory().getHardness() * 0.2f);
                this.setHarvestLevel("shovel", 0);
            }
        }
        if (type != Rock.Type.SPIKE && type != Rock.Type.ANVIL) {
            OreDictionaryHelper.registerRockType(this, type, new Object[0]);
        }
    }

    public BlockRockVariant getVariant(Rock.Type t) {
        return TABLE.get((Object)this.rock).get((Object)t);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        switch (this.type) {
            case FARMLAND: 
            case PATH: {
                switch (side) {
                    case UP: {
                        return true;
                    }
                    case NORTH: 
                    case SOUTH: 
                    case WEST: 
                    case EAST: {
                        IBlockState state = world.func_180495_p(pos.func_177972_a(side));
                        Block block = state.func_177230_c();
                        if (state.func_185914_p()) {
                            return false;
                        }
                        if (block instanceof BlockFarmland || block instanceof BlockGrassPath) {
                            return false;
                        }
                        if (block instanceof BlockRockVariant) {
                            switch (((BlockRockVariant)block).type) {
                                case FARMLAND: 
                                case PATH: {
                                    return false;
                                }
                            }
                            return true;
                        }
                        return true;
                    }
                    case DOWN: {
                        return super.func_176225_a(blockState, world, pos, side);
                    }
                }
            }
        }
        return super.func_176225_a(blockState, world, pos, side);
    }

    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        if (this.type.isGrass) {
            BlockRockVariantConnected.spreadGrass(world, pos, state, rand);
        }
        super.func_180645_a(world, pos, state, rand);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        switch (this.type) {
            case RAW: 
            case SPIKE: {
                return ItemRock.get(this.rock);
            }
            case CLAY_GRASS: 
            case CLAY: {
                return Items.field_151119_aD;
            }
            default: {
                return super.func_180660_a(state, rand, fortune);
            }
            case PATH: 
            case GRASS: 
            case DRY_GRASS: 
        }
        return Item.func_150898_a((Block)BlockRockVariant.get(this.rock, Rock.Type.DIRT));
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return this.type.isGrass ? BlockRenderLayer.CUTOUT : BlockRenderLayer.SOLID;
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        switch (this.type) {
            case CLAY_GRASS: 
            case CLAY: {
                return 4;
            }
            case RAW: 
            case SPIKE: {
                return 1 + random.nextInt(3);
            }
        }
        return super.quantityDropped(state, fortune, random);
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        IBlockState cropState;
        int beachDistance = 2;
        if (plantable instanceof BlockPlantTFC) {
            switch (((BlockPlantTFC)plantable).getPlantTypeTFC()) {
                case CLAY: {
                    return this.type == Rock.Type.DIRT || this.type == Rock.Type.GRASS || this.type == Rock.Type.DRY_GRASS || this.type == Rock.Type.CLAY || this.type == Rock.Type.CLAY_GRASS;
                }
                case DESERT_CLAY: {
                    return this.type == Rock.Type.SAND || this.type == Rock.Type.CLAY || this.type == Rock.Type.CLAY_GRASS;
                }
                case DRY_CLAY: {
                    return this.type == Rock.Type.DIRT || this.type == Rock.Type.DRY_GRASS || this.type == Rock.Type.SAND || this.type == Rock.Type.CLAY || this.type == Rock.Type.CLAY_GRASS;
                }
                case DRY: {
                    return this.type == Rock.Type.DIRT || this.type == Rock.Type.DRY_GRASS || this.type == Rock.Type.SAND;
                }
                case FRESH_WATER: {
                    return this.type == Rock.Type.DIRT || this.type == Rock.Type.GRASS || this.type == Rock.Type.DRY_GRASS || this.type == Rock.Type.GRAVEL;
                }
                case SALT_WATER: {
                    return this.type == Rock.Type.DIRT || this.type == Rock.Type.GRASS || this.type == Rock.Type.DRY_GRASS || this.type == Rock.Type.SAND || this.type == Rock.Type.GRAVEL;
                }
                case FRESH_BEACH: {
                    boolean flag = false;
                    block19: for (EnumFacing facing : EnumFacing.field_176754_o) {
                        for (int i = 1; i <= beachDistance; ++i) {
                            if (!BlocksTFC.isFreshWaterOrIce(world.func_180495_p(pos.func_177967_a(facing, i)))) continue;
                            flag = true;
                            continue block19;
                        }
                    }
                    return (this.type == Rock.Type.DIRT || this.type == Rock.Type.GRASS || this.type == Rock.Type.SAND || this.type == Rock.Type.DRY_GRASS) && flag;
                }
                case SALT_BEACH: {
                    boolean flag = false;
                    for (EnumFacing facing : EnumFacing.field_176754_o) {
                        for (int i = 1; i <= beachDistance; ++i) {
                            if (!BlocksTFC.isSaltWater(world.func_180495_p(pos.func_177967_a(facing, i)))) continue;
                            flag = true;
                        }
                    }
                    return (this.type == Rock.Type.DIRT || this.type == Rock.Type.GRASS || this.type == Rock.Type.SAND || this.type == Rock.Type.DRY_GRASS) && flag;
                }
            }
        } else if (plantable instanceof BlockCropTFC && (cropState = world.func_180495_p(pos.func_177984_a())).func_177230_c() instanceof BlockCropTFC) {
            boolean isWild = (Boolean)cropState.func_177229_b((IProperty)BlockCropTFC.WILD);
            if (isWild && (this.type == Rock.Type.DIRT || this.type == Rock.Type.GRASS || this.type == Rock.Type.DRY_GRASS || this.type == Rock.Type.CLAY_GRASS)) {
                return true;
            }
            return this.type == Rock.Type.FARMLAND;
        }
        switch (plantable.getPlantType(world, pos.func_177972_a(direction))) {
            case Plains: {
                return this.type == Rock.Type.DIRT || this.type == Rock.Type.GRASS || this.type == Rock.Type.FARMLAND || this.type == Rock.Type.DRY_GRASS || this.type == Rock.Type.CLAY || this.type == Rock.Type.CLAY_GRASS;
            }
            case Crop: {
                return this.type == Rock.Type.FARMLAND;
            }
            case Desert: {
                return this.type == Rock.Type.SAND;
            }
            case Cave: {
                return true;
            }
            case Water: {
                return false;
            }
            case Beach: {
                boolean flag = false;
                for (EnumFacing facing : EnumFacing.field_176754_o) {
                    for (int i = 1; i <= beachDistance; ++i) {
                        if (!BlocksTFC.isWater(world.func_180495_p(pos.func_177967_a(facing, i)))) continue;
                        flag = true;
                    }
                }
                return (this.type == Rock.Type.DIRT || this.type == Rock.Type.GRASS || this.type == Rock.Type.SAND || this.type == Rock.Type.DRY_GRASS) && flag;
            }
            case Nether: {
                return false;
            }
        }
        return false;
    }

    public Rock.Type getType() {
        return this.type;
    }

    public Rock getRock() {
        return this.rock;
    }

    @Override
    @Nonnull
    public Size getSize(@Nonnull ItemStack stack) {
        return Size.SMALL;
    }

    @Override
    @Nonnull
    public Weight getWeight(@Nonnull ItemStack stack) {
        return Weight.LIGHT;
    }
}

